class PausAR_WidgetHandler extends elementorModules.frontend.handlers.Base {

    getDefaultSettings() {
        return {
            selectors: {
                modelViewer: '.pausAR-UI-elementorModelViewer',
                customMVProgressBar: '.pausAR-UI-modelViewerProgressBar',
            },
        };
    }

    getDefaultElements() {
        
        const selectors = this.getSettings('selectors');
        
        return {
            $modelViewer: this.$element.find( selectors.modelViewer ),
            $customMVProgressBar: this.$element.find( selectors.customMVProgressBar ),
        };
    }

    bindEvents() {
        
        if(this.elements.$modelViewer) {
            if (this.elements.$modelViewer.length > 0) {

                this.elements.$modelViewer.on( 'mousedown', this.mvDragEvent.bind( this ) );
                this.elements.$modelViewer.on( 'touchstart', this.mvDragEvent.bind( this ) );
                
              
            }
        }        
    }

    /**
     * Used since v3.1
     * Condition for adding the Handler to the widget.
     * @param {*} settings 
     * @returns Boolean: Should the Handler get attached to the widget, according to a custom condition?
     */
    isActive( settings ) {
        return true;
    }
    //================================
    // Helpers (Recurring Events)
    //================================

    mvDragEvent(ev) {
        if(typeof elementorFrontend !== 'undefined') {
            if(elementorFrontend.isEditMode()) {
                ev.preventDefault();
                ev.stopPropagation();
            }
        }
                
    }
}

//================================
// Helpers (One-Time Events)
//================================
if(typeof jQuery !== 'undefined' && jQuery != null) {
    jQuery( window ).on( 'elementor/frontend/init', () => {

        //Init Handlers-----------------------------

        // Handler attachement since v3.1
        elementorFrontend.elementsHandler.attachHandler( 'PausAR_Viewer_Default', PausAR_WidgetHandler );

        //EventHandler

        /**
         * Generate Poster Function for the Editor
         */
        if (typeof elementor !== 'undefined') {
            
                    
            elementor.channels.editor.on('pausAR:editor:generatePreviewPosterStarter', function (e) {


                if (typeof elementorFrontend === 'undefined') {
                    return;
                } else if (!elementorFrontend.isEditMode()) {
                    return;
                }

                let widgetContainer = getWidgetContainer(e);
                
                if (!widgetContainer) {
                    return;
                }
                let mv = widgetContainer.querySelector('model-viewer');
                if (!mv) {
                    return;
                }

                mv.toBlob({ mimeType: 'image/png', idealAspect: true })
                    .then(function(mvBlob) {
                        
                        let internalFR = new FileReader();
                        internalFR.onerror = function(err) {
                            console.warn("[PausAR]: Poster-Image can't be created. Error processing image");
                            return ;
                        }
                        internalFR.onload = function(e) {//dataURL
                            let baseImg = new Image();
                            baseImg.onerror = function(err) {
                                console.warn("[PausAR]: Poster-Image can't be created. Error converting image");
                                return ;
                            }
                            baseImg.onload = function() {//Image
                                if(baseImg.complete) {
                                    addWatermark(baseImg, .8, 1, false)
                                        .then(function(result) {
                                            if(result != null) {
                                                //result.blob;
                                                //result.dataURL;
                                                downloadImage(result.blob);
                                            }
                                        })
                                        .catch(function(err) {
                                            console.warn("[PausAR]: Poster-Image can't be created. Error expanding image");
                                            return ;
                                        });
                                } else {
                                    console.warn("[PausAR]: Poster-Image can't be created. Error loading image");
                                    return ;
                                }
                            }
                            baseImg.src = e.target.result;

                        }
                        internalFR.readAsDataURL(mvBlob);
                    })
                    .catch(function(err) {
                        console.warn("[PausAR]: Poster-Image can't be created. Error creating image");
                        return ;
                    });          

            });

                

        }

        function generateUniqueFilname(prefix) {
            let temp = new Date();
            return prefix += temp.getFullYear().toString() +
                temp.getMonth().toString() +
                temp.getDate().toString() +
                temp.getHours().toString() +
                temp.getMinutes().toString() +
                temp.getSeconds().toString();
        }


        function getWidgetContainer(e, prefix) {

            //e.options.element.model.id
            //e.options.container.renderer.id
            //e.options.container.renderer.model.id

            if(typeof e === "undefined" || e == null) {
                return null;
            }
            if(typeof e.options === "undefined" || e.options == null) {
                return null;
            }

            if (typeof prefix !== 'string') {
                prefix = "pausARID-widget-";
            }

            let widgetID = "";
            
            if(typeof e.options.element !== "undefined" && e.options.element != null) {
                if(typeof e.options.element.model !== "undefined" && e.options.element.model != null) {
                    if(typeof e.options.element.model.id === "string") {
                        widgetID = prefix + e.options.element.model.id;
                    }
                }                        
            } else if(typeof e.options.container !== "undefined" && e.options.container != null) {
                if(typeof e.options.container.renderer !== "undefined" && e.options.container.renderer != null) {
                    if(typeof e.options.container.renderer.model !== "undefined" && e.options.container.renderer.model != null) {
                        if(typeof e.options.container.renderer.model.id === "string") {
                            widgetID = prefix + e.options.container.renderer.model.id;
                        }
                    } else if(typeof e.options.container.renderer.id === "string") {
                        widgetID = prefix + e.options.container.renderer.id;
                    }      
                }       
            }
            
            if(widgetID == "") {
                return null;
            }
            
            return document.querySelector(".pausAR-UI-elementorViewerContainer[pausar='" + widgetID + "']");
        }

        function addWatermark(img, opacity, sizeFactor, relativeScaling) {
            return new Promise(function(resolve, reject) {
                if(typeof img !== 'object') {
                    reject();
                    return ;
                }
                //---
                if(typeof opacity !== 'number') {
                    opacity = 1;
                } else {
                    if(opacity < 0) {
                        opacity = 0;
                    } else if(opacity > 1) {
                        opacity = 1;
                    }
                }
                if(typeof relativeScaling !== 'boolean') {
                    relativeScaling = false;
                }
                if(typeof sizeFactor !== 'number') {
                    if(relativeScaling) {
                        sizeFactor = .3333;
                    } else {
                        sizeFactor = 1;
                    }
                    
                }
                //---
                let watermark = new Image();
                watermark.onerror = function(err) {
                    console.error(err);
                    reject();
                    return ;
                }
                watermark.onload = function() {
                    
                    let innerCanvas = document.createElement('canvas'),
                    ctx = innerCanvas.getContext('2d');
            
                    ctx.canvas.width = img.width;
                    ctx.canvas.height = img.height;
            
                    //BaseLayer
                    ctx.globalAlpha = .5;
                    ctx.drawImage(img, 0, 0);
        
                    let watermarkTargetHeight = watermark.height;
                    let watermarkTargetWidth = watermark.width;
        
                    if(relativeScaling) {
                        if(img.width >= img.height) {
                            //wider or square
                            watermarkTargetHeight = img.height * ((img.width / img.height) * sizeFactor);
                            if(watermarkTargetHeight > img.height) {watermarkTargetHeight = img.height;}
                            watermarkTargetWidth = watermarkTargetHeight * (watermark.width / watermark.height);
                            
                        } else {
                            //higher
                            watermarkTargetWidth = img.width * ((img.height / img.width) * sizeFactor);
                            if(watermarkTargetWidth > img.width) {watermarkTargetWidth = img.width;}
                            watermarkTargetHeight = watermarkTargetWidth * (watermark.height / watermark.width);
                        }
                    } else {
                        watermarkTargetHeight = watermark.height * sizeFactor;
                        watermarkTargetWidth = watermark.width * sizeFactor;
                    }
        
                    //Check Fit of Layers
                    for(let c = 0; c < 2; c++) {
                        if(watermarkTargetHeight > img.height) {
                            watermarkTargetHeight = img.height
                            watermarkTargetWidth = watermarkTargetHeight * (watermark.width / watermark.height);
                        } else if(watermarkTargetWidth > img.width) {
                            watermarkTargetWidth = img.width;
                            watermarkTargetHeight = watermarkTargetWidth * (watermark.height / watermark.width);
                        } else {//Fit/Anchor
                            c = 2;
                        }
                    }                
        
                    ctx.globalAlpha = opacity;            
                    ctx.drawImage(watermark, ((img.width / 2) - watermarkTargetWidth / 2), ((img.height / 2) - watermarkTargetHeight / 2), watermarkTargetWidth, watermarkTargetHeight);
                    ctx.globalAlpha = 1;
        
                    //Manual creation of a Blob, without fetch API
                    let mimeString = "image/png";
                    let binary = atob(innerCanvas.toDataURL(mimeString).split(',')[1]);
                    var ansiiArray = [];
                    for (var i = 0; i < binary.length; i++) {
                        ansiiArray.push(binary.charCodeAt(i));
                    }            
                    let result = {
                        "dataURL": innerCanvas.toDataURL(mimeString),
                        "blob": new Blob([new Uint8Array(ansiiArray)], { type: mimeString })
                    };           
                    resolve(result);
                }        
                watermark.src = `data:image/svg+xml,%3Csvg width='140' height='180' version='1.1' viewBox='0 0 37.042 47.625' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'%3E%3Cdefs%3E%3ClinearGradient id='b' x1='-215.87' x2='-180.05' y1='479.69' y2='479.69' gradientTransform='translate(296.02 -321.28)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23fff' offset='0'/%3E%3Cstop stop-color='%23fff' offset='.45'/%3E%3Cstop stop-color='%23d9d9d9' offset='.55'/%3E%3Cstop stop-color='%23d9d9d9' offset='1'/%3E%3C/linearGradient%3E%3ClinearGradient id='a' x1='-197.96' x2='-180.05' y1='482.69' y2='451.68' gradientTransform='translate(296.02 -321.28)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23d9d9d9' offset='0'/%3E%3Cstop stop-color='%23fff' offset='.53137'/%3E%3C/linearGradient%3E%3ClinearGradient id='f' x1='155.88' x2='173.21' y1='165' y2='135' gradientTransform='matrix(-.43889 0 0 .43889 -156.55 92.465)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23800000' offset='0'/%3E%3Cstop stop-color='%23800000' offset='.41449'/%3E%3Cstop stop-color='%23980005' offset='.51308'/%3E%3Cstop stop-color='%23a30000' offset='.60161'/%3E%3Cstop stop-color='%23a30000' offset='1'/%3E%3C/linearGradient%3E%3ClinearGradient id='e' x1='108.25' x2='125.57' y1='247.5' y2='217.5' gradientTransform='matrix(-.43889 0 0 .43889 -177.46 56.256)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23999' offset='.27'/%3E%3Cstop stop-color='%23e3e3e3' offset='1'/%3E%3C/linearGradient%3E%3ClinearGradient id='d' x1='47.631' x2='30.311' y1='137.5' y2='167.5' gradientTransform='matrix(-.43889 0 0 .43889 -204.06 86.979)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23d9d9d9' offset='0'/%3E%3Cstop stop-color='%23fff' offset='.05835'/%3E%3Cstop stop-color='%23fff' offset='.43676'/%3E%3Cstop stop-color='%23f2f2f2' offset='.52008'/%3E%3Cstop stop-color='%23f2f2f2' offset='.95985'/%3E%3Cstop stop-color='%23d9d9d9' offset='1'/%3E%3C/linearGradient%3E%3ClinearGradient id='c' x1='155.88' x2='138.56' y1='180' y2='210' gradientTransform='matrix(-.43889 0 0 .43889 -156.55 68.326)' gradientUnits='userSpaceOnUse'%3E%3Cstop stop-color='%23c82128' offset='0'/%3E%3Cstop stop-color='%23c82128' offset='.94455'/%3E%3Cstop stop-color='%23971c1e' offset='1'/%3E%3C/linearGradient%3E%3C/defs%3E%3Cg transform='translate(-79.535 -120.83)'%3E%3Cpath d='m80.15 149.07v6.35c0 1.6926 0.90261 3.2567 2.3683 4.1031l13.169 7.6026c0.72013 0.41578 1.5378 0.63502 2.3694 0.6351v5.2e-4c0.8314-1.5e-4 1.6478-0.21939 2.3678-0.6351l13.169-7.6026c1.4659-0.84636 2.3689-2.4104 2.3688-4.1031v-6.3505z' fill='url(%23b)'/%3E%3Cpath d='m98.055 121.52c-0.8314 1.5e-4 -1.6478 0.21939-2.3678 0.6351l-13.169 7.6026c-1.4659 0.84636-2.3689 2.4104-2.3688 4.1031v15.205c0 1.6926 0.9026 3.2567 2.3683 4.1031l13.169 7.6026c0.72013 0.41578 1.5378 0.63502 2.3694 0.6351v5.2e-4c0.8314-1.5e-4 1.6478-0.21939 2.3678-0.6351l13.169-7.6026c1.4659-0.84636 2.3689-2.4104 2.3688-4.1031v-15.205c0-1.6926-0.90311-3.2567-2.3688-4.1031l-13.169-7.6026c-0.72011-0.41578-1.5373-0.63502-2.3688-0.6351z' fill='url(%23a)'/%3E%3Cg transform='matrix(2.0841 0 0 2.0841 566.9 -183.87)'%3E%3Cpath d='m-231.83 151.97-0.54105 0.2868-0.1757 0.38189-8e-3 0.0951a2.0113 2.0113 0 0 0-9e-3 0.14676v6.4554a2.0113 2.0113 0 0 0 1.0056 1.742l0.64905 0.37465 2.0112 1.1612 2.93 1.6919a2.0113 2.0113 0 0 0 2.0112 0l1.7896-1.0335a2.0113 2.0113 0 0 0 1.0056-1.742v-9.5601z' fill='url(%23f)' stroke-linecap='round' stroke-linejoin='round' stroke-miterlimit='12.7' stroke-opacity='.21176' stroke-width='.87778'/%3E%3Cpath d='m-224.97 150.84 4.5611 2.6334v5.2667l-4.5611 2.6334-4.5611-2.6334v-5.2667z' fill='url(%23e)' stroke-linecap='round' stroke-linejoin='round' stroke-miterlimit='12.7' stroke-width='.52667'/%3E%3Cpath class='UnoptimicedTransforms' d='m-224.97 147.64a2.0113 2.0113 0 0 1 1.0056 0.26945l5.5905 3.2276a2.0113 2.0113 0 0 1 1.0056 1.7418v6.4553a2.0113 2.0113 0 0 1-1.0056 1.7418l-5.5905 3.2276a2.0113 2.0113 0 0 1-2.0113 0 0.67044 0.67044 0 0 0 0.14674 0.0608 0.67044 0.67044 0 0 0 0.0517 0.0111 0.67044 0.67044 0 0 0 0.1091 0.0143 0.67044 0.67044 0 0 0 0.0553 0 0.67044 0.67044 0 0 0 0.10909-0.0143 0.67044 0.67044 0 0 0 0.0517-0.0111 0.67044 0.67044 0 0 0 0.14674-0.0608 0.67044 0.67044 0 0 0 0.12656-0.0971 0.67044 0.67044 0 0 0 0.0345-0.0383 0.67044 0.67044 0 0 0 0.0665-0.0866 0.67044 0.67044 0 0 0 0.029-0.0504 0.67044 0.67044 0 0 0 0.042-0.10093 0.67044 0.67044 0 0 0 0.0159-0.049 0.67044 0.67044 0 0 0 0.0209-0.15831v-6.4553a2.0113 2.0113 0 0 0-1.0056-1.7418l-2.7954-1.6139-0.62529-0.36085-0.13473-0.0778-1.1404-0.65841-0.89474-0.51665a0.67044 0.67044 0 0 0-9.2e-4 -4.4e-4 0.67044 0.67044 0 0 0-0.28419-0.0875 0.67044 0.67044 0 0 0-0.7176 0.60942 2.0113 2.0113 0 0 1 0.92966-1.6339 0.67044 0.67044 0 0 1 0.0104-7e-3 2.0113 2.0113 0 0 1 0.0624-0.0417h2.2e-4l5.5905-3.2276a2.0113 2.0113 0 0 1 1.0056-0.26945z' fill='url(%23d)' stroke-linejoin='round' stroke-miterlimit='12.7' stroke-width='.43889'/%3E%3Cpath d='m-217.37 156.98v2.3499a2.0113 2.0113 0 0 1-1.0056 1.7418l-5.5905 3.2276a2.0113 2.0113 0 0 1-2.0111 0 0.67044 0.67044 0 0 0 0.14652 0.0608 0.67044 0.67044 0 0 0 0.0517 0.0109 0.67044 0.67044 0 0 0 0.10909 0.0143 0.67044 0.67044 0 0 0 0.0553 0 0.67044 0.67044 0 0 0 0.10909-0.0143 0.67044 0.67044 0 0 0 0.0517-0.0109 0.67044 0.67044 0 0 0 0.14675-0.0608 0.67044 0.67044 0 0 0 0.12655-0.0971 0.67044 0.67044 0 0 0 0.0345-0.0383 0.67044 0.67044 0 0 0 0.0664-0.0866 0.67044 0.67044 0 0 0 0.029-0.0504 0.67044 0.67044 0 0 0 0.042-0.10093 0.67044 0.67044 0 0 0 0.0159-0.049 0.67044 0.67044 0 0 0 0.0209-0.15831v-2.3499z' fill='url(%23c)'/%3E%3Cpath d='m-220.87 154.53-1.4328 0.91688-0.0672 0.397 0.20141-0.11628c0.25746-0.14864 0.33587-0.11934 0.33587 0.11945 0 0.16417-0.72762 3.8529-0.87314 4.6682-0.0672 0.36712-0.0895 0.40985-0.49246 0.6425l-0.0784 0.44828 1.8695-1.0794 0.0782-0.44812c-0.39178 0.21125-0.45884 0.19038-0.45884-4e-3 0-0.16418 0.0448-0.41391 0.29104-1.6456l0.0112-6e-3c0.14552 0.30403 0.38052 0.34729 0.7611 0.12755 0.96265-0.55578 1.7575-2.3281 1.7575-3.6116 0-0.86565-0.3805-1.2878-1.0297-0.91293-0.44774 0.25851-0.73895 0.71019-1.0076 1.2981l-0.0112-8e-3zm0.51486 0.25514c0.22387-0.12925 0.41403-0.06 0.41403 0.41758 0 0.44773-0.13434 1.197-0.29105 1.7502-0.20148 0.74316-0.4028 1.098-0.66025 1.2466-0.26865 0.1551-0.42551-0.0378-0.42551-0.38107 0-0.44773 0.10071-0.96849 0.23503-1.5535 0.19029-0.75164 0.43672-1.3118 0.72775-1.4798z' fill='%23231f20' fill-rule='evenodd'/%3E%3C/g%3E%3Cpath d='m81.919 156.25c0-0.57795 1e-5 -1.1559 4e-5 -1.7338l0.55738 0.32189c0.21122 0.12198 0.34891 0.21016 0.41306 0.26456 0.0986 0.0829 0.18111 0.18736 0.24761 0.3133 0.0665 0.12514 0.0998 0.2567 0.0998 0.39468 1e-5 0.10644-0.0192 0.18486-0.0575 0.23525-0.0384 0.0504-0.0873 0.0793-0.14668 0.0868-0.0587 7e-3 -0.11853-2.5e-4 -0.17955-0.0221-0.0829-0.0313-0.20303-0.0924-0.36029-0.1832l-0.22649-0.13079c0 0.21801 0 0.43602 1e-5 0.65403-0.11578-0.0669-0.23156-0.13372-0.34735-0.20058zm0.34738-1.2399v0.49201l0.19011 0.10978c0.13691 0.0791 0.22845 0.12286 0.27461 0.13138 0.0462 9e-3 0.0822 9.3e-4 0.10796-0.0228 0.0266-0.0233 0.0399-0.0606 0.0399-0.11182 0-0.0631-0.0184-0.12573-0.0551-0.18795-0.0368-0.0622-0.0833-0.11475-0.13965-0.15755-0.0415-0.0318-0.12478-0.0839-0.24996-0.15615-0.0559-0.0323-0.11185-0.0646-0.16778-0.0969zm1.1771 1.4745c-1e-5 -0.11039 0.027-0.20164 0.0809-0.27377 0.054-0.0721 0.13024-0.10692 0.22881-0.1044 0.0994 3e-3 0.21005 0.0397 0.3321 0.11019 0.18854 0.10888 0.34307 0.26001 0.46358 0.45337 0.1205 0.19259 0.18078 0.3831 0.18081 0.57154 3e-5 0.19002-0.061 0.31248-0.18302 0.36736-0.12126 0.0546-0.27422 0.0285-0.45886-0.0781-0.11424-0.066-0.22338-0.15501-0.32745-0.26715-0.10328-0.11169-0.18191-0.23318-0.23591-0.36447-0.054-0.13209-0.081-0.27028-0.081-0.41457v1e-5zm0.33799 0.21291c1e-5 0.12458 0.0294 0.23692 0.0881 0.33704s0.13106 0.17502 0.21712 0.22472c0.0861 0.0497 0.15804 0.0581 0.21593 0.0253 0.0587-0.0323 0.088-0.11159 0.088-0.23775-2e-5 -0.123-0.0294-0.23456-0.0881-0.33467-0.0579-0.0997-0.12989-0.17435-0.21595-0.22405-0.0861-0.0497-0.15842-0.0584-0.21709-0.026-0.0587 0.0324-0.088 0.11081-0.088 0.23539zm1.4389 1.4588c-0.13148-0.49455-0.263-0.98913-0.39454-1.4837l0.32037 0.18501c0.0779 0.31935 0.15583 0.6387 0.23372 0.95803 0.0716-0.23304 0.14307-0.4661 0.21456-0.69916l0.31802 0.18365c0.0693 0.31439 0.13866 0.62876 0.20796 0.94313 0.0794-0.22852 0.15869-0.45706 0.23798-0.68561l0.32507 0.18771c-0.13321 0.34169-0.2665 0.68333-0.39985 1.025l-0.31688-0.18298c-0.0716-0.31058-0.14326-0.62117-0.21491-0.93178-0.0703 0.22861-0.14072 0.4572-0.21111 0.68579zm2.3589 0.9624c0.10954 0.0818 0.21908 0.16355 0.32862 0.24532-0.0422 0.097-0.10909 0.15104-0.20063 0.16203-0.0908 0.0107-0.20459-0.0235-0.34151-0.1026-0.21672-0.12514-0.37712-0.2891-0.4812-0.49189-0.0822-0.16177-0.12328-0.32977-0.12333-0.50402-6e-5 -0.20816 0.0539-0.33981 0.16178-0.39496 0.10791-0.0559 0.2444-0.0362 0.40947 0.0591 0.18542 0.10707 0.33175 0.25346 0.439 0.43915 0.10724 0.18491 0.15858 0.40336 0.15397 0.65532l-0.82621-0.47709c2e-3 0.0998 0.0289 0.19207 0.0799 0.2767 0.0509 0.0838 0.11427 0.14756 0.19014 0.19137 0.0516 0.0298 0.0951 0.0407 0.13027 0.0326 0.0352-8e-3 0.0618-0.0384 0.0798-0.0911v5e-5zm0.0187-0.32504c-2e-3 -0.0975-0.0269-0.18464-0.074-0.26149-0.047-0.0775-0.10408-0.13575-0.17137-0.1746-0.072-0.0416-0.13142-0.0495-0.17834-0.0237-0.0469 0.0257-0.07 0.0841-0.0692 0.17527 0.1643 0.0949 0.32859 0.18971 0.49289 0.28457zm0.91207 1.2622-0.32978-0.19043c-6e-5 -0.41863-2.1e-4 -0.83731-4.6e-4 -1.256l0.30629 0.17688c3e-5 0.0595 7e-5 0.11907 1e-4 0.1786 0.0524-0.0541 0.0993-0.0826 0.14072-0.0855 0.0422-2e-3 0.0899 0.0118 0.14315 0.0425 0.0751 0.0434 0.14748 0.10606 0.21714 0.18806-0.034 0.0769-0.0679 0.15389-0.10193 0.23083-0.0556-0.0683-0.10721-0.11629-0.15493-0.14385-0.0462-0.0267-0.0853-0.0362-0.11734-0.0288-0.032 7e-3 -0.0575 0.0381-0.0762 0.0943-0.018 0.0566-0.0269 0.19178-0.0268 0.40546 5e-5 0.12929 8e-5 0.25859 1.1e-4 0.38788zm1.3413 0.37487c0.10954 0.0818 0.21909 0.16354 0.32863 0.24531-0.0422 0.097-0.10907 0.15103-0.20061 0.16203-0.0907 0.0107-0.20458-0.0235-0.34149-0.1026-0.21673-0.12515-0.37713-0.28911-0.48123-0.4919-0.0822-0.16175-0.12329-0.32975-0.12336-0.504-9e-5 -0.20816 0.0538-0.33982 0.16169-0.39497 0.10789-0.0559 0.24436-0.0362 0.40943 0.0591 0.18541 0.10708 0.33176 0.25347 0.43903 0.43916 0.10727 0.18492 0.15865 0.40337 0.15407 0.65533l-0.8262-0.47709c2e-3 0.0998 0.0289 0.19207 0.0799 0.2767 0.0509 0.0838 0.11428 0.14756 0.19015 0.19137 0.0516 0.0298 0.0951 0.0407 0.13026 0.0326 0.0352-8e-3 0.0618-0.0384 0.0798-0.0911v6e-5zm0.0186-0.32505c-2e-3 -0.0975-0.0269-0.18464-0.074-0.2615-0.047-0.0775-0.1041-0.13574-0.17138-0.1746-0.072-0.0416-0.13142-0.0495-0.17834-0.0238-0.0469 0.0257-0.07 0.0842-0.0691 0.17528 0.16429 0.0949 0.32859 0.18971 0.49288 0.28457zm1.7395 1.7399-0.30632-0.17688c-1e-5 -0.0615-2e-5 -0.12298-4e-5 -0.18447-0.0509 0.0424-0.11109 0.0612-0.18069 0.0565-0.0688-5e-3 -0.13848-0.0279-0.2089-0.0686-0.14318-0.0827-0.26602-0.21155-0.36855-0.38662-0.10174-0.17542-0.15264-0.36719-0.15275-0.57534-1.1e-4 -0.2129 0.0495-0.34586 0.14873-0.39889 0.0993-0.0538 0.22479-0.0369 0.37657 0.0507 0.13925 0.0804 0.25979 0.20835 0.36159 0.38379-1.7e-4 -0.20819-3.8e-4 -0.41639-6.2e-4 -0.62462l0.32974 0.19042c7e-4 0.57815 1e-3 1.1561 1e-3 1.734zm-0.88045-1.1634c8e-5 0.13404 0.0185 0.24163 0.0553 0.32278 0.0532 0.11744 0.12757 0.20372 0.22303 0.25885 0.0759 0.0438 0.14043 0.0488 0.19361 0.0148 0.0532-0.0347 0.0797-0.11673 0.0797-0.24604-8e-5 -0.14429-0.026-0.2629-0.0777-0.3558-0.0517-0.0937-0.11783-0.16382-0.1984-0.21034-0.0782-0.0452-0.14393-0.0516-0.19708-0.0192-0.0524 0.032-0.0785 0.11033-0.0785 0.2349zm1.8592 1.7286c-1.4e-4 -0.57783-6e-4 -1.1558-1e-3 -1.734l0.32974 0.19043c2.8e-4 0.20823 5.3e-4 0.41645 7.3e-4 0.62464 0.10159-0.058 0.222-0.0468 0.36126 0.0336 0.15178 0.0876 0.27741 0.21576 0.37688 0.38433 0.0995 0.16779 0.14932 0.35538 0.14947 0.56275 1.5e-4 0.21447-0.0506 0.35027-0.1523 0.40742-0.10089 0.0576-0.22372 0.0446-0.36846-0.039-0.0712-0.0411-0.14162-0.0995-0.21126-0.17519-0.0689-0.076-0.12834-0.16356-0.17844-0.26265 2e-5 0.0615 4e-5 0.12299 5e-5 0.18447zm0.32713-0.46609c8e-5 0.13011 0.0205 0.23804 0.0612 0.32382 0.0572 0.12128 0.13307 0.20925 0.22774 0.26392 0.0728 0.042 0.13456 0.0466 0.18539 0.0136 0.0516-0.0332 0.0774-0.11728 0.0773-0.2521-1e-4 -0.14351-0.026-0.26172-0.0777-0.35463-0.0517-0.0937-0.11785-0.16382-0.19842-0.21035-0.079-0.0456-0.14471-0.0524-0.19707-0.0204-0.0524 0.0312-0.0785 0.10994-0.0784 0.23609zm0.99813-0.0242 0.35088 0.20262c0.0997 0.35471 0.19935 0.70937 0.29888 1.064 0.0969-0.2412 0.1936-0.48246 0.29023-0.72377l0.3415 0.1972c-0.14617 0.31832-0.29255 0.63652-0.43912 0.95463-0.0262 0.0578-0.0524 0.11556-0.0786 0.17333-0.0289 0.0566-0.0567 0.0965-0.0833 0.11977-0.0258 0.0237-0.0559 0.0375-0.0904 0.0412-0.0337 5e-3 -0.0755-2.7e-4 -0.12558-0.0158-0.0493-0.0151-0.10522-0.0407-0.16783-0.0768-0.0634-0.0366-0.12558-0.0792-0.1866-0.12782-0.01-0.0923-0.0195-0.18468-0.0293-0.27703 0.0517 0.0401 0.0982 0.0721 0.13966 0.096 0.0767 0.0443 0.1334 0.0542 0.17016 0.0297 0.0368-0.0237 0.0649-0.065 0.0845-0.12384-0.15817-0.51101-0.31653-1.0221-0.47506-1.5334zm2.1661 1.2115c0.10862 0.046 0.2188 0.0879 0.33026 0.12589 7e-5 0.0615 1.4e-4 0.12301 2.1e-4 0.18451 0.0434-0.0483 0.10213-0.0801 0.17697-0.0971 0.0748-0.017 0.15833-0.0136 0.25081 9e-3 0.16155 0.0394 0.30005 0.12206 0.41464 0.25459 0.11457 0.1325 0.17223 0.29727 0.17236 0.50216 1.3e-4 0.20942-0.0578 0.36694-0.17307 0.46554-0.11513 0.0977-0.25436 0.12985-0.41567 0.0903-0.0767-0.0188-0.14611-0.0515-0.2082-0.0972-0.0612-0.0454-0.12563-0.11277-0.19297-0.20236 6e-5 0.21098 6e-5 0.42198 0 0.633-0.11972-0.0402-0.23798-0.085-0.35445-0.1344 0-1e-5 -8.9e-4 -1.7339-8.9e-4 -1.7339zm0.35127 0.7396c1e-4 0.14096 0.0303 0.25618 0.0912 0.34311 0.0609 0.0862 0.1354 0.14197 0.22393 0.16539 0.0851 0.0225 0.1564 8e-3 0.21335-0.0408 0.057-0.0499 0.0856-0.14622 0.0855-0.28731-8e-5 -0.1319-0.0297-0.23515-0.0885-0.31194-0.0589-0.0768-0.13141-0.12559-0.21738-0.14843-0.0894-0.0238-0.1629-0.0143-0.22115 0.0304-0.0582 0.0439-0.087 0.12647-0.0869 0.2496l-2e-5 -1e-5zm1.575 0.0403c-0.1144-0.0193-0.22877-0.0424-0.34286-0.0693 0.0384-0.11866 0.10451-0.20355 0.19865-0.25836 0.0947-0.0551 0.23354-0.0806 0.41977-0.0886 0.16933-7e-3 0.29289-3e-3 0.37564 0.0233 0.0821 0.0252 0.13921 0.0611 0.17212 0.11072 0.0337 0.0485 0.0505 0.14472 0.0506 0.28913-5e-5 6e-3 -4e-3 0.38292-4e-3 0.38877 1e-5 0.11046 6e-3 0.19121 0.0173 0.24219 0.0124 0.05 0.035 0.10236 0.0677 0.15649-0.12273 0.0219-0.24625 0.0392-0.37025 0.052-0.01-0.0211-0.0219-0.0526-0.0362-0.0946-6e-3 -0.0191-0.0108-0.0317-0.0134-0.0378-0.0643 0.0612-0.13315 0.10791-0.20659 0.13947-0.0734 0.0316-0.1519 0.048-0.23532 0.0486-0.14698 1e-3 -0.26342-0.0392-0.34836-0.11441-0.0842-0.0753-0.1262-0.1681-0.12624-0.27541-3e-5 -0.0711 0.0192-0.13242 0.0576-0.18483 0.0385-0.0532 0.0921-0.0922 0.16116-0.11857 0.0706-0.0273 0.16967-0.05 0.30133-0.0744 0.17523-0.0318 0.30034-0.0702 0.36674-0.10073-1e-5 -0.011-1e-5 -0.0221-1e-5 -0.0332-3e-5 -0.064-0.0179-0.10761-0.0537-0.13166-0.036-0.025-0.10315-0.0335-0.20289-0.0298-0.0673 3e-3 -0.11967 0.0151-0.15739 0.0391-0.0377 0.0232-0.0682 0.0636-0.0914 0.12175l-3.2e-4 -2e-5zm0.5055 0.25031c-0.0475 0.0181-0.12545 0.0418-0.22955 0.0659-0.1054 0.0243-0.17295 0.0434-0.20578 0.0628-0.0493 0.0309-0.0739 0.0695-0.0739 0.11688 2e-5 0.0466 0.0198 0.0871 0.0593 0.12105 0.0395 0.0339 0.0897 0.0505 0.15069 0.0487 0.0681-2e-3 0.1331-0.025 0.19483-0.0686 0.0456-0.033 0.0756-0.0723 0.0899-0.11692 0.01-0.0292 0.0147-0.0837 0.0147-0.16342l-4e-5 -0.0663zm1.6237 0.18172c0-0.0627 2e-5 -0.1253 4e-5 -0.18795-0.0476 0.0884-0.11068 0.16903-0.18982 0.23944-0.0784 0.0702-0.16213 0.12079-0.25139 0.15111-0.0909 0.0309-0.17344 0.0374-0.2468 0.0211-0.0734-0.0163-0.12695-0.055-0.16001-0.11388-0.0331-0.0589-0.0497-0.14777-0.0497-0.26608 1e-5 -0.26506 6e-5 -0.53012 1.6e-4 -0.79516 0.12276-0.0289 0.24447-0.0624 0.36479-0.10052-1.8e-4 0.19247-3.2e-4 0.38494-4.1e-4 0.57739-8e-5 0.17666 6e-3 0.28309 0.0191 0.31919 0.0137 0.0351 0.038 0.0587 0.0728 0.0706 0.0349 0.011 0.079 7e-3 0.132-0.0126 0.0606-0.0225 0.11452-0.0593 0.16188-0.10954 0.0474-0.051 0.0796-0.10383 0.0969-0.15706 0.0173-0.0541 0.026-0.17111 0.0263-0.35084 2.1e-4 -0.17662 5e-4 -0.35327 8.6e-4 -0.52995 0.10617-0.0471 0.21078-0.0981 0.31355-0.15299 5.6e-4 -3e-4 1e-3 -6e-4 2e-3 -9e-4l0.0254-0.0147c-1e-3 0.41869-2e-3 0.83714-2e-3 1.2553-8e-3 5e-3 -0.0169 0.01-0.0254 0.0147-6.2e-4 3.4e-4 -1e-3 6.8e-4 -2e-3 1e-3 -0.0946 0.0507-0.19076 0.0982-0.28829 0.1423zm0.54115-0.64621c0.11034-0.0806 0.22068-0.16129 0.33101-0.24194 0.014 0.0565 0.0425 0.0892 0.0856 0.0982 0.043 8e-3 0.10323-0.01 0.18072-0.0548 0.0853-0.0492 0.14945-0.10203 0.1925-0.15838 0.029-0.0388 0.0435-0.0767 0.0435-0.1137 2e-5 -0.0252-8e-3 -0.0416-0.0234-0.0491-0.0164-6e-3 -0.0532 3.7e-4 -0.11028 0.02-0.26596 0.0945-0.43451 0.1379-0.50565 0.13015-0.0985-0.0108-0.14766-0.0766-0.14744-0.19715 2e-4 -0.10878 0.043-0.22486 0.12848-0.34821 0.0854-0.12336 0.21776-0.23677 0.39691-0.34023 0.17056-0.0985 0.29723-0.14368 0.38003-0.13559 0.0828 8e-3 0.13976 0.0579 0.17086 0.14939-0.1037 0.0792-0.2074 0.15837-0.3111 0.23756-0.0132-0.0412-0.0386-0.0639-0.0761-0.0683-0.0367-5e-3 -0.0895 0.0127-0.15836 0.0525-0.0868 0.0502-0.14907 0.0983-0.18667 0.1444-0.025 0.0318-0.0376 0.0615-0.0377 0.0891-4e-5 0.0236 0.0109 0.0374 0.0328 0.0413 0.0297 5e-3 0.13213-0.0231 0.30733-0.0842 0.17598-0.0614 0.29875-0.0831 0.36831-0.065 0.0688 0.0193 0.10311 0.0818 0.10302 0.18739-1e-4 0.11503-0.0479 0.24146-0.14338 0.37928-0.0955 0.13783-0.23673 0.26071-0.42373 0.36869-0.1698 0.098-0.30438 0.14109-0.40372 0.12914-0.0986-0.0124-0.16306-0.0692-0.19347-0.17059 0-2e-5 1e-5 -5e-5 1e-5 -8e-5zm1.4155-0.92127c1.1e-4 -0.11071 2.4e-4 -0.22143 4e-4 -0.33216l0.64785-0.37408c-1.6e-4 0.11073-2.8e-4 0.22145-3.8e-4 0.33216zm0.8145-1.2629 0.30395-0.17552c-1.2e-4 0.0572-2.2e-4 0.11431-3.2e-4 0.17147 0.10898-0.19602 0.23859-0.33742 0.3888-0.42416 0.0798-0.0461 0.14901-0.0695 0.20762-0.0702 0.0586-8e-4 0.10665 0.0215 0.1441 0.0668 0.0549-0.0986 0.11401-0.18279 0.17745-0.2525 0.0634-0.0697 0.13114-0.12538 0.20311-0.16694 0.0915-0.0529 0.16896-0.0787 0.23227-0.0774 0.0633 4.5e-4 0.11055 0.0279 0.14174 0.0824 0.0226 0.0405 0.0339 0.12065 0.0337 0.24045-3.1e-4 0.26758-4.9e-4 0.53509-5.4e-4 0.80253l-0.32981 0.19042c6e-5 -0.23908 2.1e-4 -0.47821 4.7e-4 -0.7174 1.3e-4 -0.12453-0.0111-0.19837-0.0337-0.22152-0.0304-0.0297-0.0773-0.0262-0.14073 0.0104-0.0462 0.0267-0.0896 0.0659-0.13033 0.1178-0.0407 0.0519-0.0701 0.11061-0.0882 0.17616-0.0181 0.0648-0.0272 0.15626-0.0273 0.27448-2e-4 0.20095-3.2e-4 0.40186-3.7e-4 0.60273l-0.32981 0.19042c6e-5 -0.22922 2.1e-4 -0.4585 4.7e-4 -0.68784 1.4e-4 -0.12216-6e-3 -0.19758-0.0173-0.22627-0.0117-0.0287-0.03-0.0445-0.055-0.0474-0.0242-3e-3 -0.0575 7e-3 -0.0997 0.0316-0.0509 0.0294-0.0967 0.0696-0.13738 0.1207-0.0407 0.0511-0.0701 0.10786-0.0882 0.17025-0.0173 0.062-0.026 0.15325-0.0261 0.27381-2.2e-4 0.20331-3.5e-4 0.40658-4e-4 0.60981l-0.32981 0.19042c1e-4 -0.41826 5.7e-4 -0.83671 1e-3 -1.2554zm2.8825-0.8091c0.10954-0.0447 0.21907-0.0895 0.3286-0.13421-0.0423 0.14573-0.10923 0.27693-0.20081 0.39361-0.0908 0.11543-0.20463 0.21267-0.34156 0.29173-0.21674 0.12514-0.37714 0.14647-0.48114 0.0639-0.0821-0.0668-0.12312-0.18727-0.12296-0.36143 1.9e-4 -0.20804 0.0544-0.402 0.16253-0.58179 0.10814-0.18059 0.24476-0.31856 0.40983-0.41388 0.18542-0.10707 0.33162-0.12967 0.43865-0.0678 0.10703 0.0611 0.15805 0.22027 0.15318 0.47751l-0.82625 0.47708c2e-3 0.0972 0.0287 0.1587 0.0797 0.1844 0.0508 0.025 0.11422 0.0156 0.19009-0.0282 0.0517-0.0298 0.0951-0.0691 0.1303-0.11779 0.0352-0.0487 0.0618-0.10977 0.0799-0.18318v5e-5zm0.019-0.34654c-2e-3 -0.0949-0.0267-0.15355-0.0737-0.17604-0.0469-0.0233-0.10397-0.0155-0.17126 0.0233-0.072 0.0416-0.13147 0.1023-0.17847 0.18222-0.047 0.0799-0.0702 0.16498-0.0695 0.25516 0.1643-0.0949 0.3286-0.18977 0.4929-0.28466zm1.739-0.26912-0.30633 0.17687c1e-5 -0.0615 3e-5 -0.12291 5e-5 -0.18437-0.0509 0.10108-0.11117 0.18944-0.18079 0.2651-0.0689 0.0744-0.13851 0.13197-0.20892 0.17263-0.14319 0.0827-0.26604 0.0957-0.3685 0.0391-0.10168-0.0579-0.15248-0.19082-0.15231-0.39887 1.6e-4 -0.21277 0.05-0.40306 0.14953-0.57079 0.0995-0.16852 0.22514-0.29661 0.37692-0.38425 0.13926-0.0804 0.25966-0.0917 0.36124-0.0337 2.3e-4 -0.20809 5.1e-4 -0.41622 8.5e-4 -0.62437l0.32972-0.19042c-8.9e-4 0.57793-1e-3 1.1556-1e-3 1.7331zm-0.87995-0.14655c-1.1e-4 0.13397 0.0182 0.22028 0.0549 0.25894 0.0532 0.056 0.12748 0.0564 0.22294 1e-3 0.0759-0.0438 0.14046-0.1134 0.19369-0.20873 0.0532-0.0961 0.0799-0.2088 0.08-0.33805 1e-4 -0.14421-0.0256-0.23294-0.0772-0.26617-0.0516-0.034-0.11767-0.0278-0.19824 0.0188-0.0782 0.0452-0.14399 0.11465-0.19726 0.20844-0.0525 0.0925-0.0788 0.20107-0.0789 0.32558zm1.206-1.4668c1.2e-4 -0.10249 2.6e-4 -0.20497 4.1e-4 -0.30747l0.32973-0.19042c-1.4e-4 0.10249-2.7e-4 0.20498-3.9e-4 0.30746zm-9.8e-4 1.4257c6e-5 -0.41836 3.2e-4 -0.83683 7.8e-4 -1.2554l0.32977-0.19043c-4.4e-4 0.41857-6.8e-4 0.83704-7.4e-4 1.2554zm1.3897-1.2019c0.10954-0.0447 0.21908-0.0895 0.32861-0.13421-0.0423 0.14575-0.10919 0.27696-0.20076 0.39365-0.0908 0.11544-0.20462 0.21269-0.34156 0.29175-0.21673 0.12514-0.37714 0.14645-0.48116 0.0639-0.0821-0.0668-0.12316-0.1873-0.12306-0.36146 1.1e-4 -0.20805 0.0542-0.40199 0.1623-0.58178 0.10807-0.18057 0.24465-0.31853 0.40973-0.41385 0.18541-0.10708 0.33166-0.12968 0.43875-0.0678 0.1071 0.0611 0.15823 0.22024 0.15343 0.47749l-0.82624 0.47708c2e-3 0.0972 0.0287 0.15871 0.0797 0.18442 0.0509 0.025 0.11423 0.0156 0.19011-0.0282 0.0517-0.0298 0.0951-0.0691 0.13029-0.11779 0.0352-0.0487 0.0618-0.10977 0.0798-0.18319v5e-5zm0.0189-0.34655c-2e-3 -0.0949-0.0267-0.15355-0.0738-0.17603-0.0469-0.0233-0.10401-0.0155-0.17129 0.0233-0.072 0.0416-0.13146 0.1023-0.17844 0.18222-0.047 0.0799-0.0701 0.16497-0.0694 0.25515 0.1643-0.0949 0.3286-0.18977 0.4929-0.28466zm1.7298-0.26364-0.32981 0.19042c1e-5 -0.21354 6e-5 -0.4271 1.3e-4 -0.64067 5e-5 -0.13556-7e-3 -0.21898-0.021-0.25027-0.014-0.0321-0.0371-0.0499-0.0692-0.0534-0.0313-4e-3 -0.0692 7e-3 -0.11382 0.0326-0.0571 0.033-0.10837 0.0783-0.15376 0.13604-0.0454 0.0577-0.0767 0.11757-0.0939 0.17953-0.0165 0.0615-0.0247 0.16243-0.0248 0.30269-6e-5 0.18953-1.1e-4 0.37905-1.3e-4 0.56856l-0.3298 0.19042c5e-5 -0.4184 2.2e-4 -0.83688 5.2e-4 -1.2554l0.3063-0.17687c-4e-5 0.0615-8e-5 0.12296-1.2e-4 0.18443 0.10883-0.20466 0.24579-0.35466 0.41086-0.44999 0.0728-0.042 0.13926-0.067 0.19948-0.075 0.0602-9e-3 0.10559-2e-3 0.13608 0.0219 0.0313 0.0229 0.0527 0.057 0.0645 0.10225 0.0125 0.0448 0.0187 0.11567 0.0187 0.2126-8e-5 0.26009-1.3e-4 0.52017-1.3e-4 0.78023zm0.33449-0.19313c1e-5 -0.11072 2e-5 -0.22143 4e-5 -0.33216l0.32981-0.19043c-2e-5 0.11073-3e-5 0.22145-4e-5 0.33216zm1.811-1.0456-0.30634 0.17687c0-0.0615 1e-5 -0.12294 1e-5 -0.18441-0.0509 0.1011-0.11113 0.18948-0.18076 0.26514-0.0688 0.0744-0.13849 0.13198-0.20891 0.17264-0.14319 0.0827-0.26603 0.0957-0.36852 0.039-0.10171-0.0579-0.15255-0.19087-0.15251-0.39893 4e-5 -0.21278 0.0498-0.40304 0.14917-0.57076 0.0994-0.1685 0.22498-0.29658 0.37675-0.38422 0.13926-0.0804 0.25973-0.0917 0.36142-0.0338 3e-5 -0.20806 7e-5 -0.41613 1.2e-4 -0.6242l0.32974-0.19042c-9e-5 0.57769-1.5e-4 1.1554-1.7e-4 1.733zm-0.88019-0.14665c-2e-5 0.13398 0.0183 0.2203 0.0551 0.25897 0.0532 0.056 0.12752 0.0564 0.22298 1e-3 0.0759-0.0438 0.14045-0.11341 0.19366-0.20875 0.0532-0.0961 0.0798-0.20882 0.0798-0.33807 2e-5 -0.14422-0.0258-0.23295-0.0774-0.26617-0.0517-0.034-0.11775-0.0278-0.19832 0.0188-0.0782 0.0452-0.14397 0.11465-0.19718 0.20842-0.0524 0.0925-0.0787 0.20107-0.0787 0.32558zm1.9271-0.85739c0.10954-0.0447 0.21908-0.0895 0.32862-0.13421-0.0422 0.14576-0.10914 0.27699-0.20069 0.3937-0.0908 0.11545-0.20462 0.21271-0.34155 0.29177-0.21673 0.12514-0.37714 0.14643-0.4812 0.0639-0.0822-0.0668-0.12322-0.18734-0.12321-0.36151 1e-5 -0.20806 0.054-0.40198 0.16199-0.58176 0.10797-0.18056 0.24449-0.3185 0.40956-0.41382 0.18542-0.10707 0.33172-0.12969 0.43892-0.0679 0.1072 0.0611 0.15846 0.22021 0.15378 0.47747l-0.82625 0.47709c2e-3 0.0972 0.0288 0.15872 0.0798 0.18444 0.0509 0.025 0.11425 0.0156 0.19013-0.0282 0.0516-0.0298 0.0951-0.0691 0.13028-0.1178 0.0352-0.0487 0.0618-0.10978 0.0798-0.18321v6e-5zm0.0188-0.34657c-2e-3 -0.0949-0.0269-0.15355-0.0739-0.17603-0.0469-0.0233-0.10406-0.0155-0.17134 0.0233-0.072 0.0416-0.13144 0.1023-0.17839 0.18222-0.0469 0.0799-0.07 0.16496-0.0693 0.25514 0.1643-0.0949 0.32861-0.18977 0.49291-0.28466z' aria-label='Powered by paus-medien.de'/%3E%3C/g%3E%3C/svg%3E`;
            });
        }

        function downloadImage(blobFile) {

            if(typeof blobFile === 'undefined') {
                return ;
            }
            if(blobFile == null) {
                return ;
            }
            //---
            let filename = generateUniqueFilname("PausAR_Poster_") + ".png";
            let file = new File([blobFile], filename, { type: 'image/png' });
            let mvBlobURL = webkitURL.createObjectURL(file);
            //let mvBlobURL = URL.createObjectURL(file);
            let downloadElement = document.createElement('a');
            downloadElement.href = mvBlobURL;
            downloadElement.download = filename;
            /*
            downloadElement.dispatchEvent(
                new MouseEvent('click', {
                    bubbles: true,
                    cancelable: true,
                    view: window
                })
            );
            */
            downloadElement.click();
            webkitURL.revokeObjectURL(mvBlobURL);
            //URL.revokeObjectURL(mvBlobURL);


        }

        //-----------------------
        // Style-Changes
        //-----------------------

        //Global Variables

        //let pausAREditorStylesheet;
        //pausAREditorStylesheet = document.createElement("style");

        let basicDisableStyle = '.elementor-control.pausAR-UI-elementorDisabled {\
            pointer-events: none !important;\
            opacity: 0.4 !important;\
        }';//.replace(/\s\s+/g, ' ');

        let badgeStyleLabel = '.elementor-control.pausAR-UI-elementorDisabled .elementor-control-title::before {\
            content: "Pro";\
            pointer-events: all !important;\
            background-color: #d4d4d4;\
            cursor: pointer;\
            color: black;\
            padding: 1px 4px;\
            border-radius: 4px;\
            margin: 0 8px 0 0;\
            font-size: calc(var(--control-title-size, 12px) - 1px);\
        }';//.replace(/\s\s+/g, ' ');
                
        (function() {
            if(typeof elementorFrontend !== 'undefined') {
                if(!elementorFrontend.isEditMode()) {
                    return ;
                }
            } else {
                return ;
            }
            elementor.hooks.addAction('panel/open_editor/widget/PausAR_Viewer_Default', function (panel, model, view) {

                //if(typeof jQuery === 'undefined' || jQuery == null) {
                //    return ;
                //}

                if (typeof top === 'object') {
                    if (typeof top.document === 'object') {
                        addingStylesheetsAndRules(top.document);
                    } else {
                        addingStylesheetsAndRules();
                    }
                } else {
                    addingStylesheetsAndRules();
                }

                function addingStylesheetsAndRules(docRoot) {
                    if(typeof docRoot !== 'object') {
                        docRoot = document;
                    }
                    //Adding new StyleElement
                    /*
                    pausAREditorStylesheet.textContent = basicDisableStyle + badgeStyleLabel;
                    if (!pausAREditorStylesheet.isConnected) {
                        docRoot.head.appendChild(pausAREditorStylesheet);
                    }
                    */

                    //Adding StyleRules to Elementor Style
                    for (let x = 0; x < docRoot.styleSheets.length; x++) {
                        if (typeof docRoot.styleSheets[x].href === 'string') {
                            if (docRoot.styleSheets[x].href.indexOf("elementor/assets/css/editor") >= 0) {

                                if (typeof docRoot.styleSheets[x].insertRule === "function") {
                                    let disableProUIAdded = false;//Checks for existence of a '.pausAR-UI-elementorDisabled' rule
                                    for (let rule = 0; rule < docRoot.styleSheets[x].cssRules.length; rule++) {
                                        if (docRoot.styleSheets[x].cssRules[rule].cssText.indexOf(".pausAR-UI-elementorDisabled") >= 0) {
                                            disableProUIAdded = true;
                                        }
                                    }
                                    if(!disableProUIAdded) {
                                        docRoot.styleSheets[x].insertRule(badgeStyleLabel);
                                        docRoot.styleSheets[x].insertRule(basicDisableStyle);
                                    }
                                }
                            }
                        }
                    }
                }

                //Adding Inline-Styles and UI Changes
                
                if (typeof panel === 'undefined' || panel == null) {
                    return;
                }

                let tabHeader = panel.$el.find('.elementor-panel-navigation');
                if (tabHeader.length) {
                    tabHeader[0].onclick = changeTab;
                }
                let sectionHeaders = panel.$el.find('.elementor-control-type-section');
                if (sectionHeaders.length) {
                    for (let s = 0; s < sectionHeaders.length; s++) {
                        sectionHeaders[s].onclick = changeTab;
                    }
                }

                changeTab();

                function changeTab() {

                    let restrictedUI = panel.$el.find(".pausAR-UI-elementorDisabled");

                    for (let y = 0; y < restrictedUI.length; y++) {
                        restrictedUI[y].style.pointerEvents = "none";
                        restrictedUI[y].style.opacity = .4;

                        let switchInput = restrictedUI[y].querySelector("input");//alt: .elementor-switch-input
                        if (switchInput) {
                            switchInput.disabled = true;
                        }


                        let controlLabel = restrictedUI[y].querySelector("label.elementor-control-title");
                        if (controlLabel) {
                            controlLabel.onclick = function () { top.window.open("https://www.pausarstudio.de/wordpress-elementor/#pricing", '_blank').focus(); }
                        }

                    }

                    //Renew Events
                    if (tabHeader.length) {
                        tabHeader[0].onclick = null;//Remove old Event
                    }
                    let tabHeaderNew = panel.$el.find('.elementor-panel-navigation');
                    if (tabHeaderNew.length) {
                        tabHeaderNew[0].onclick = changeTab;
                    }

                    if (sectionHeaders.length) {
                        for (let s = 0; s < sectionHeaders.length; s++) {
                            sectionHeaders[s].onclick = null;//Remove old Event
                        }
                    }
                    let sectionHeadersNew = panel.$el.find('.elementor-control-type-section');
                    if (sectionHeadersNew.length) {
                        for (let s = 0; s < sectionHeadersNew.length; s++) {
                            sectionHeadersNew[s].onclick = changeTab;
                        }
                    }
                }
                
            });
        })();

    });
}