<?php
/* Template Name: Construction */
if( ! defined('ABSPATH')){
    exit;
}

$viewport_content = apply_filters( 'hello_elementor_viewport_content', 'width=device-width, initial-scale=1' );
$enable_skip_link = apply_filters( 'hello_elementor_enable_skip_link', true );
$skip_link_url = apply_filters( 'hello_elementor_skip_link_url', '#content' );
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="<?php echo esc_attr( $viewport_content ); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body <?php body_class('elementor-page-23'); ?>>

<?php wp_body_open(); ?>

<?php if ( $enable_skip_link ) { ?>
<a class="skip-link screen-reader-text" href="<?php echo esc_url( $skip_link_url ); ?>"><?php echo esc_html__( 'Skip to content', 'hello-elementor' ); ?></a>
<?php } ?>

<?php
if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) {
	if ( hello_elementor_display_header_footer() ) {
		if ( did_action( 'elementor/loaded' ) && hello_header_footer_experiment_active() ) {
			get_template_part( 'template-parts/dynamic-header' );
		} else {
			get_template_part( 'template-parts/header' );
		}
	}
}
?>
<style>
    .loader {
        border: 10px solid #f3f3f3;
        border-radius: 50%;
        border-top: 10px solid #3498db;
        width: 50px;
        height: 50px;
        -webkit-animation: spin 2s linear infinite; /* Safari */
        animation: spin 2s linear infinite;
        margin: auto
    }

    /* Safari */
    @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .get_construction{
        color: var(--e-global-color-primary);
        border: 1px solid var(--e-global-color-primary );
        font-size: 14px;
        padding: 10px 15px;
        margin-right: 5px;
        -webkit-transition: all .2s ease;
        transition: all .2s ease;
    }
    .get_construction.active{
        background-color: var(--e-global-color-primary);
        color: #fff
    }
    .get_construction:hover{
        background-color: var(--e-global-color-primary);
        color: #fff;
        opacity: .6;
    }
    .divider{
        border-top: 1px solid var(--e-global-color-primary);;
        height: 1px;
        width: 100%;
        margin-top: 30px;
    }
</style>
<main id="content" class="site-main">
    <div class="page-content">
        <div data-elementor-type="wp-page" class="elementor" data-elementor-post-type="page">
            <?php
            if (pll_current_language() == 'en')
                echo do_shortcode('[elementor-template id="720"]');
            else
                echo do_shortcode('[elementor-template id="579"]');
    
            echo '<div data-elementor-type="container" class="elementor" data-elementor-post-type="elementor_library">';
                echo '<div class="elementor-element e-flex e-con-boxed e-con e-parent e-lazyloaded" data-element_type="container" style="display:flex">';
                echo '<div class="e-con-inner">';
                $constructions = new WP_Query([
                    'post_type' => 'construction',
                    'posts_per_page' => -1,
                    'nopaging'       => true,
                    'post_status' => 'publish',
                    'order' => 'DESC'
                ]);
    
                $post_id = 0;
                if(isset($_GET['id'])){
                    $post_id = $_GET['id'];
                }
                //echo $post_id;
                if($constructions->have_posts()){
                    while ($constructions->have_posts()) : 
                        $constructions->the_post();
                        $post_id == 0?$post_id = get_the_ID():'';
                        echo '<a class="get_construction'. ($post_id == get_the_ID()?' active':'') .'" href="'. site_url('construction') .'/?id='. get_the_ID() .'" postId="'. get_the_ID() .'">' .get_the_title(). '</a>';   
                    endwhile;
                    wp_reset_postdata();
                }
                ?>
                <div class="divider"></div>
                </div></div>
            </div>
            <div class="load_container" style="margin: 15px 0 50px">
                <div class="loader hide"></div>
                <div class="load_construction">
                    <?php
                    if($post_id == 0){
                        esc_html_e( 'Sorry, no posts matched your criteria.' );
                    }else{
                        $post   = get_post( $post_id );
                        $output =  apply_filters( 'the_content', $post->post_content );
                        echo $output;
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php 
get_footer();
?>

